# 功能获得研究中的伦理困境：H5N1流感病毒研究案例研究

* 1191200221 数媒2002 陈云豪

# 一、人类抗击流感的历史

纵观⼈类历史，我们与病毒的⽃争⼀直在持续。直到20世纪初，科学家们才开始真正了解病毒。这些实体与细菌不同，能够通过细菌过滤器，由包裹在蛋⽩质壳中的简单核酸组成，并且仅在宿主细胞内复制。1918年的西班⽛流感（H1N1）在全球造成了5000万⼈死亡，当时在很⼤程度上仍然是⼀个谜，科学家们根据巴斯德和科赫的主导细菌学理论推测细菌原因。上个世纪，爆发了三场重⼤流感：1957年的亚洲流感（H2N2）、1968年的⾹港流感和2009年美国的H1N1流感。这些流⾏病对⼈类健康和社会经济结构产⽣了深远影响，导致严重的社会恐慌。学者们将这些影响⽐作“病毒效应”，类似于蝴蝶效应，给⼈类带来了前所未有的挑战。

随着现代⽣物技术的进步，我们对流感等病毒的了解显着提⾼。然⽽，季节性流感和各种动物流感亚型继续对公众健康构成威胁。迄今为⽌，除了疫苗外，还没有⾼效的抗病毒药物。病毒的进化和变异之快令⼈震惊。对病毒的研究通常涉及研究结构、⽣物学从已识别病原体的特征和流⾏病学数据。⼀些科学家进⾏“先发制⼈”的⼲预，利⽤DNA重组技术创造新的突变株，改变病毒的宿主或增加其致病性。这种⽅法被称为“功能获得研究”，旨在更好地为公共卫⽣和预防⼯作提供信息，但引发了围绕⽣物安全的相当⼤争议。

# 二、事件经过

事件发⽣的时间顺序涉及威斯康星⼤学⻨迪逊分校的Yoshihiro Kawaoka教授，他是⼀位致⼒于流感和埃博拉病毒研究的病毒学家，同时也是东京⼤学微⽣物学和免疫学系的教授。他的研究对理解流感病毒的致病机制、跨物种传播、抗原研究和疫苗开发做出了重⼤贡献，尽管并⾮没有争议。2013年，川冈当选美国国家科学院外籍院⼠。从2008年开始，在美国国⽴卫⽣研究院（NIH）的资助下，川冈开展了与H5N1流感病毒传播的分⼦特征相关的研究。

2011年8⽉31⽇，川冈向《⾃然》杂志提交了⼀篇论⽂，揭⽰了对该病毒进⾏的基因改造以提⾼其传播能⼒。他⽤2009年H1N1病毒株的H1部分替换了转基因H5N1流感病毒的H5部分，创造了⼀种可以通过雪貂呼吸道⻜沫传播的变种。这是典型的功能获得研究，旨在了解病毒的进化机制，增强其毒⼒和传播能⼒。

与此同时，荷兰Erasmus MC的Ron AM Fouchier博⼠对H5N1病毒进⾏了突变诱导研究，并于2011年8⽉30⽇向《科学》杂志提交了⼀篇论⽂，讨论了H5N1禽流感病毒的空⽓传播。研究表明，H5N1的部分基因改造可以显着增加其在雪貂等哺乳动物中的传播能⼒。通过基因⼯程融合五种⾃然发⽣的突变，H5N1病毒的加速进化是可以实现的。收到这两篇论⽂后，由于公开研究结果和数据存在潜在⻛险，编辑们很快将其转发给国家⽣物安全科学咨询委员会（NSABB）。

在9.11袭击和随后的炭疽邮件攻击之后，⼈们对⽣命科学研究的恶意应⽤越来越关注。2004年报告《恐怖主义时代的⽣物技术研究》呼吁仔细审查双重⽤途研究，澄清⼀些研究成果对恐怖主义的意义。报告还建议政府采取⾏动，建⽴国家⽣物安全咨询委员会，并实施适当的⽣物安全措施。因此，美国政府针对⽣物恐怖主义威胁采取了各种措施，包括对⽣命科学和⽣物技术领域的双重⽤途研究进⾏监管，最终导致了国家安全局的成⽴。该委员会服务于卫⽣与公众服务部并⾪属于NIH，由不超过25名有投票权的成员组成。其职责包括为⽣命科学两⽤研究的⽣物安全监管提供指导和建议，为相关学科的科学家、实验室⼈员、学⽣和学员提供教育、培训和发展建议，为相关学科的出版和公众传播提供建议。军⺠两⽤研究成果，提出⿎励国际社会参与⽣命科学军⺠两⽤研究管理的战略，并为军⺠两⽤研究及其研究成果的实施、交流和监督提供政策建议。

尽管这两项H5N1研究在改善流感⼤流⾏的监测、预测、预防、诊断和治疗⽅⾯具有潜在的公共卫⽣意义，但不可否认的滥⽤⻛险仍然存在。因此，所有NSABB成员都参与了有关这些研究的讨论。经过五周半的深思熟虑、分析两篇论⽂中的数据并权衡发布信息的⻛险和收益后，NSABB于2011年11⽉21⽇建议《⾃然》和《科学》杂志重新编辑这两篇论⽂。建议是公布关键结论，省略数据和⽅法，只与值得信赖的专家和机构分享。这是NSABB⾃2004年成⽴以来⾸次提出如此限制性的建议。这⼀决定引发了众多争议，⼀些⼈认为这是学术审查和对科学⾃由的侵犯，⽽另⼀些⼈则认为科学的双重⽤途性质需要某些妥协。

# 三、争议

围绕NSABB对功能获得研究观点的争议引发了对该研究价值的重新考虑。⽀持者认为，Fouchier研究的五个基因突变是在天然H5N1中发现的，有助于早期⼤流⾏预警。川冈的研究有助于了解病毒传播和进化。然⽽，实验室泄漏等⻛险引起了⼈们的担忧，⼀些专家主张反对此类研究，因为它们可能被滥⽤，包括⽣物恐怖主义。

2012年1⽉20⽇，NIH发布了⼀份关于NSABB对H5N1研究的审查的声明，建议暂不发表完整的⼿稿以防⽌滥⽤。因此，卫⽣部向Kawaoka、Fouchier和期刊编辑提供了NSABB的⾮强制性建议。与此同时，包括Kawaoka 和 Fouchier在内的研究⼈员宣布⾃愿暂停H5N1研究60天，等待国际社会就负责任地处理研究进⾏讨论。这⼀暂停适⽤于增强⾼致病性禽流感在哺乳动物中传播能⼒的实验。

这场争议引起了公众的关注，引发了有关⾼⻛险病毒的创建、存储和潜在滥⽤的问题。世卫组织于 2012年2⽉举⾏了技术磋商会，以澄清事实并讨论与该研究相关的⽣物安全问题。参与者回顾了研究的各个⽅⾯，包括实验室实践和资⾦监督。会议得出的结论是，基因修饰数据对于改善公共和动物健康监测很有价值，但需要与滥⽤的可能性进⾏权衡。世卫组织随后召开了另⼀次会议，主张在不进⾏编辑的情况下发表该研究，并讨论了有效沟通策略的必要性，以增强公众对H5N1研究的理解。他们还就病毒储存、⽣物安全标准和未来研究许可等问题进⾏了辩论。会议同意改善H5N1研究的实验室条件，建⽴综合监测体系。

2012年3⽉29⽇⾄30⽇，NSABB召开第⼆次会议，回顾了历次会议信息和国际意⻅，重新评估了发表建议，并建议全⽂发表两篇论⽂。NSABB还发布了《美国政府对令⼈关注的⽣命科学双重⽤途研究的监督政策》，表⽰该政策的⽬的是定期审查美国政府资助或进⾏的某些⾼致病性微⽣物的研究，以降低⻛险，收集必要的信息信息，维护⽣命科学研究的利益，同时最⼤限度地减少滥⽤此类研究中的知识、信息、产品或技术的⻛险。该政策补充了美国政府关于拥有和处理病原微⽣物的现有法规和政策，为研究⼈员、国家安全官员和全球卫⽣专家提供了指导。

2012年5⽉1⽇，美国国家科学院科学、技术和法律委员会与⽣命科学委员会联合举办了⼀次名为“微⽣物威胁论坛”的为期⼀天的公共研讨会。研讨会的⽬的是“探索从研究概念化到发表的全⽅位⼲预点”，讨论当前的研究法规和监督，以及考虑新机制的建⽴和实施。

2012年6⽉22⽇，川冈义宏在《⾃然》杂志上发表了题为《Experimental adjustment of anfluenus H5 HA conffersrespiratorydroplet Transmission to a reassorant H5 HA/H1N1virus》的论⽂。该研究强调需要为H5HA流感病毒引起的潜在⼤流⾏做好准备。这些知识将使研究⼈员能够监测正在流⾏或新出现的变种的⼤流⾏潜⼒，将精⼒集中在这些⾄关重要的病毒亚群分⼦变化上，在病毒流⾏的地区储备抗病毒复合物，并在病毒流⾏之前启动疫苗⽣产和⼤规模⽣产。此外，川冈义博同⽇在《Science》杂志上发表论⽂《The Maybe Interspecies Transmission of A/H5N1 Influenza Virus via Respiratory Droplets in the Mammalian Host》，提出A/H5N1流感病毒可能只发⽣5个氨基酸取代或四种重组以实现哺乳动物之间的呼吸道⻜沫传播，构成⼤流⾏威胁。其中两个替换在A/H5N1病毒中很常⻅，⽽某些病毒可能只需要三个额外的替换即可在哺乳动物之间进⾏呼吸道⻜沫传播。因此，本研究通过利⽤宿主内病毒进化的数学模型来研究哺乳动物宿主中病毒感染后剩余取代增加或减少的概率，从⽽调查此类病毒在⾃然界中进化的潜在威胁。

随着这些论⽂的发表，围绕H5N1研究的紧张⽓氛逐渐缓解，川冈义博和富希耶于2012年10⽉提出，由于观察到⾃然突变，解除对A/H5N1流感研究的临时禁令并恢复⼯作，这对⼈类健康构成了新的威胁。在政府和相关机构的批准下，实验室病毒与⾃然病毒之间的竞赛重新开始。2013年2⽉1⽇，川冈义博等⼈正式宣布恢复研究，表⽰对A/H5N1流感病毒传播的研究对于预防⼤流⾏和了解该病毒对哺乳动物的适应⾄关重要。然⽽，科学家不应该在缺乏必要条件和监管制度的实验室中进⾏类似的研究。

2014年7⽉3⽇，川冈义弘创造出“超级H1N1病毒”来分析H1N1的基因变化，绕过⼈体免疫系统的关键步骤，再次引起重⼤争议。不过，川冈义弘对H1N1和H5N5流感病毒的研究仍在继续，从2014年⾄今已发表百余篇论⽂。尽管2018年之后研究成果已难以检索，但Fouchier还在呼吸道病毒、禽流感病毒、冠状病毒等领域继续进⾏研究，从2013年⾄今发表了约百篇论⽂。

# 四、 案列分析

增益功能研究，尤其是在病毒学领域，涉及操纵病毒以更好地理解它们的机制，包括它们引发大流行的潜力。虽然这项研究对于预防和控制未来的疫情至关重要，但它引发了重大的伦理关切，因为它具有双重用途性质，可能会创造更具毒性或传播性的病毒株的可能性。关键的伦理关切包括

1. **风险与利益:** 基因功能研究（GoF），尤其是在病毒学领域，涉及操纵病毒以更好地理解它们的机制，包括它们可能引发大流行的潜力。尽管这项研究对预防和控制未来的疫情爆发至关重要，但由于其双重用途性质以及可能创建更具毒性或传播性的病毒菌株的可能性，它引发了重大的道德担忧。主要的道德关切点包括：
3. **双重用途困境:** 基因功能研究体现了经典的“双重用途”困境，科学发现旨在造福人类，但也可能被用于有害目的。这引发了关于研究人员和机构确保其工作不落入不法之手的道德担忧。这还引起了国际协议和监管机制的全面需要，以规范研究并防止其被用于生物恐怖主义或其他恶意用途。
4. **透明度与安全性:** 基因功能研究中透明度与安全性之间的辩论是一个有争议的问题。支持透明度的人认为信息的公开分享加速了科学进展并促进了合作，而强调安全性的人强调有必要限制对敏感信息的访问，以防止滥用。取得平衡需要综合考虑因素，如出版物中的细节水平、滥用的可能性以及合作研究的好处。
5. **监管和监督挑战:** 有效监管和监督基因功能研究对于确保其安全进行至关重要。然而，现有的监管框架可能无法跟上生物技术的迅速发展。挑战包括确定适当的监督水平，确保合规性而不妨碍科学创新，并根据新兴技术和方法适应监管。
6. **全球合作和标准制定:** 在全球大流行威胁面前，基因功能研究中的国际合作至关重要。这不仅涉及分享研究结果，还包括在不同国家和研究机构之间协调安全标准和协议。道德考虑包括确保对研究数据的公平访问、尊重不同文化和道德观点，以及合作进行全球风险评估和管理策略。
7. **研究人员的道德责任:** 从事基因功能研究的研究人员必须在复杂的道德环境中航行，平衡追求科学知识与公共健康潜在风险的追求。这一责任不仅限于遵守安全协议，还包括考虑其工作的更广泛社会影响，参与道德辩论，并积极参与风险评估和管理讨论。
8. **知情同意和公众参与:** 与公众讨论基因功能研究是维护公众信任和确保社会与科学事业保持一致的重要环节。这包括对利益和风险进行透明传达，解决公众关切，并在适当的情况下将外行人纳入决策过程中。知情同意的概念，通常适用于个体研究参与者，可以在基因功能研究的社会背景下扩展。
9. **谨慎原则:** 谨慎原则主张在可能对公共健康构成威胁的研究中，应偏向谨慎一侧。在基因功能研究的背景下，这可能意味着在风险不完全了解或无法充分管理时，延迟、修改或甚至停止某些研究。这种方法强调在进行潜在危险的研究之前进行风险预防和慎重考虑。
10. **全球治理:** 有效的基因功能研究全球治理对于管理生物安全风险至关重要。这需要国际合作，以建立和执行研究指导方针，分享最佳实践，并确保安全标准得到一致应用。挑战包括调和监管方法的差异，促进国际合作，以及确保所有参与方的合规性。
11. **科学家的道德教育:** 对科学家，特别是从事双重用途研究的科学家，道德教育的重要性不可低估。道德培训应融入科学教育，强调批判性思维、研究的社会影响和负责任的行为。这种教育还应处理与基因功能研究相关的具体挑战和责任，培养科学家的道德意识和决策能力。
12. **媒体和传播的作用:** 科学发现，尤其是那些潜在风险的发现，如何向公众传播是至关重要的。媒体机构有责任负责任地报道基因功能研究，避免制造轰动和误导。准确和平衡的报道对于向公众传达研究的复杂性和其影响是至关重要的，从而促进公众形成明智和理性的公共讨论。
13. **出版伦理:** 期刊和出版商在决定是否以及如何发布敏感的基因功能研究结果时面临伦理挑战。困境在于平衡开放的科学交流需要，这有助于合作和进步，与提供可能被滥用的信息之间的风险。出版商必须在维护学术自由和科学进展原则的同时，应对问题，如同行评审、敏感细节的删除以及遵守监管指南。
14. **知识产权与公共卫生:** 在基因功能研究的背景下，知识产权（IP）权利引发了关于保护研究人员和机构权利与确保公众访问科学发现之间平衡的伦理问题，特别是在全球健康背景下。在疫苗或治疗方法可能由于知识产权而受限制的情况下，利润动机与解决公共卫生需求之间的紧张关系尤为明显，引发了关于公平和全球卫生正义的担忧。
15. **监测与吹哨:** 建立有效的基因功能研究监测系统和创造一个可以自由提出道德关切的环境是研究治理的重要组成部分。这包括实施对研究活动的持续监测机制，确保遵守道德标准，并保护揭露不道德行为或安全违规的吹哨者。
16. **道德决策框架:** 应用结构化的伦理框架，如功利主义、义务论或德性伦理，可以指导复杂基因功能研究场景中的决策。这些框架提供了系统化的方法来评估研究的道德维度，考虑行动的后果、遵守道德原则以及研究人员的美德品质的因素。
17. **风险沟通和教育:** 开发清晰而有效的沟通策略对于向科学界、政策制定者、利益相关者和广大公众传达与基因功能研究相关的风险和利益至关重要。这包括制定易于理解、透明和能够回应不同受众关切和价值观的信息。
18. **未来影响:** 考虑基因功能研究的长期影响是必要的。今天的决策可能对未来的科学实践、公共卫生和公众对科学的信任产生深远影响。这种前瞻性方法需要仔细考虑当前研究可能如何影响未来的科学能力、道德规范和社会对科学的态度。
19. **社会对科学的信任:** 基因功能研究如何进行和传播在塑造公众对科学的信任方面发挥着重要作用。维护这种信任需要透明度、道德行为和有效的沟通策略，以准确传达研究的风险和利益。
20. **伦理标准的演进:** 科学中的伦理标准并不是静态的；它们随着社会价值观和技术进步而演变。对新的伦理挑战作出响应需要持续的对话、反思和伦理标准的调整，这些挑战是由科学进展带来的。
21. **紧急情况准备和响应:** 基因功能研究突显了强大的紧急情况准备和响应策略的需要。这包括制定应对可能由研究活动引发的潜在爆发的全面计划，包括快速响应能力和应急计划。
22. **跨学科合作:** 在基因功能研究的决策过程中，涉及来自不同领域的专家，如伦理学家、社会学家和公共政策专家，可以确保更全面和道德上更合理的方法。这种合作可以提供不在科学界内明显的宝贵见解和观点。
23. **科学中的道德领导:** 科学界的道德领导力涉及设定标准，指导未来研究者，并营造一个将伦理考虑融入研究过程的环境。领导者在塑造其机构和更广泛的科学界伦理文化方面发挥关键作用。

每个方面，从个体研究者的责任到全球治理和公共沟通，都为复杂的伦理风景作出了贡献。在这个风景中导航需要持续的对话，跨学科的合作，以及在科学进步与公共安全和伦理完整性之间取得平衡的承诺。

# 五、结论和启示

**结论：** 围绕H5N1功能获得性研究（GoF）的争论展示了科学进步和伦理责任之间复杂的相互作用。这项旨在增进我们对流感病毒的了解的研究具有重大风险，包括可能创建更危险的病原体的潜在风险。这一困境强调了科学努力中全面的伦理框架、透明的公开讨论和科研活动的严格监管的必要性，特别是在具有双重用途潜力的领域。

围绕GoF研究的伦理难题是多层次的。首先，风险与利益的分析至关重要。一方面，GoF研究为我们提供了有关病毒机制的宝贵见解，有可能引领疫苗技术和大流行准备方面的突破性发展。另一方面，创建可能更易传播或更致命的病毒株的风险不可低估。这种风险并非纯理论性的，正如过去实验室病毒株逃脱控制的事件所示，尽管通常是较不危险的病毒株。

GoF研究的双重用途性质进一步复杂化了伦理格局。虽然主要目标是为了促进公共福祉的科学知识，但同样的研究也可能被滥用于有害目的，如生物战争或生物恐怖主义。这种可能性要求采取主动的生物安全方法，平衡科学公开性与防范滥用的需求。

透明度和公众参与在应对这些伦理挑战中至关重要。科学界必须与公众、政策制定者和国际机构进行公开和诚实的对话。这种沟通不仅应涉及研究结果的传播，还应包括风险说明以及采取的风险缓解措施。特别是在GoF研究中，公众对科学的信任依赖于这种透明度。

GoF研究中固有的监管和监督挑战。国家生物安全科学顾问委员会（NSABB）等机构的作用至关重要，但他们面临的挑战是制定确保安全而不妨碍科学进步的准则。监管框架必须是动态的，能够适应生物技术的快速发展和生物安全威胁的演变。

国际合作至关重要，考虑到GoF研究的全球影响。大流行不尊重国界，因此，对生物安全和伦理标准的协作方法是必要的。这种合作应该不仅限于政府，还应包括国际组织、研究机构和全球范围内的科学家。

伦理责任是GoF研究的核心。研究人员必须意识到他们的工作的更广泛影响，遵守伦理原则和严格的安全协议。这一责任还包括考虑他们的研究对公共卫生和环境可能产生的长期影响。

预防原则提倡在风险尚未完全了解的情况下采取保守的方法，特别是在GoF研究等领域，这可能意味着在谨慎方面出错，实施严格的安全措施，并在某些情况下暂停某些研究方向，直到对风险有更清晰的理解。

全球治理GoF研究是一个紧迫的问题。制定和执行国际标准和协议对确保统一的安全和伦理实践至关重要。这需要国家、国际组织和科学界的共同努力，以确立生物安全措施和伦理准则的共同基础。

科学家的伦理教育是一个重要组成部分。参与GoF和其他双重用途研究领域的研究人员必须接受不仅仅是技术技能方面的培训，还包括伦理学的理解。这种培训应包括对伦理原则、生物安全风险以及他们工作的社会影响的理解。

媒体在向公众传达科学发现方面的作用比以往任何时候都更重要。准确和负责任的报道对于提供公众理解、避免制造不实信息和恐惧至关重要。

在发布敏感科学信息方面的伦理考虑是至关重要的。出版商和期刊必须平衡科学界对数据的开放访问需求与传播敏感信息可能带来的风险之间的关系。

在GoF研究中，知识产权和公共卫生经常陷入僵局。尤其是在全球卫生危机背景下，拥有专有技术或发现的伦理问题引发了对拯救生命技术和治疗方法的获取问题，特别是在资源有限的情况下。

在研究机构内部监控和举报机制对于维护伦理标准至关重要。研究人员应该能够在不受报复的情况下提出对不道德行为的担忧，应该有机制能够迅速有效地处理这些问题。

伦理决策框架提供了一个结构化的方法，用于导航GoF研究伦理复杂格局。这些框架帮助研究人员和政策制定者评估他们决策的道德影响，考虑潜在结果、社会影响和道德职责。

风险沟通和教育是必不可少的，特别是在GoF研究等领域，其中风险重大且常常难以为非专家理解。制定有效的沟通策略，向公众、政策制定者和科学界传达这些风险的信息对于知情决策至关重要。

GoF研究的未来影响深远。今天做出的决策将塑造科学研究的轨迹，影响公共卫生政策，并影响公众对科学的信任，这些将持续多年。因此，必须考虑这项研究的长期后果，包括它将如何影响未来的科学实践和社会对科学的看法。

社会对科学的信任是有效科学研究和公共卫生政策的基石。GoF研究的进行方式、监管方式和传播策略在塑造这种信任方面发挥着重要作用。维护公众信任需要承诺透明度、伦理行为和有效的沟通策略。

科学伦理标准的演变是一个持续的过程。随着科学知识的进步和社会价值观的变化，伦理标准必须发展以应对新的挑战，并确保科学研究继续为公共利益服务。

在GoF研究的背景下，紧急准备和响应至关重要。必须制定强大的策略和计划来应对可能由研究活动引发的疫情或事故。这涉及不仅仅是科学和医疗方面的应对，还包括与公共卫生部门、政府和国际组织的协调努力。

跨学科合作对于应对GoF研究的伦理挑战至关重要。涉及各个领域的专家，包括伦理学、社会学、法律和公共政策，确保更全面的决策方法，并有助于识别和解决在纯粹科学角度可能不明显的伦理问题。

科学中的伦理领导不仅仅是制定规则和准则。它涉及培养科学界的伦理责任文化，指导未来的研究人员，并以身作则。科学界的领导者在塑造其领域的伦理标准和实践、影响研究如何进行以及如何应对伦理挑战方面发挥着关键作用。

**启示：** H5N1 GoF研究案例激发了对科学伦理决策过程的重新评估，强调了需要一体化的方法，包括公众参与、政府间合作和研究人员的伦理教育。这个案例提醒人们科学研究的全球影响以及预见和缓解潜在风险的重要性。它强调了生物安全的主动和协同方法的必要性，平衡知识追求与保护公共健康和安全的责任。

这个案例还强调了在科学界培养伦理责任文化的重要性。这不仅包括遵守已建立的伦理准则和安全协议，还包括鼓励开放的讨论和对研究更广泛影响的批判性思考。这呼吁改变科学家的培训方式，强调伦理考虑与技术专业知识同等重要。
